/*
 * Decompiled with CFR 0.152.
 */
package name.panitz.game2d.simple;

import java.awt.event.KeyEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import name.panitz.game2d.Game;
import name.panitz.game2d.GameObj;
import name.panitz.game2d.ImageObject;
import name.panitz.game2d.TextObject;
import name.panitz.game2d.Vertex;

final class SimpleGame
extends Record
implements Game {
    private final GameObj player;
    private final List<List<? extends GameObj>> goss;
    private final int width;
    private final int height;
    private final int[] schaden;
    private final List<GameObj> hintergrund;
    private final List<GameObj> gegner;
    private final List<GameObj> wolken;
    private final List<GameObj> texte;

    SimpleGame() {
        this(new ImageObject(new Vertex(200.0, 200.0), new Vertex(1.0, 1.0), "hexe.png"), new ArrayList(), 800, 600, new int[1], new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList());
    }

    @Override
    public void init() {
        this.goss().clear();
        this.goss().add(this.hintergrund());
        this.goss().add(this.gegner());
        this.goss().add(this.wolken());
        this.goss().add(this.texte());
        this.hintergrund().clear();
        this.gegner().clear();
        this.wolken().clear();
        this.texte().clear();
        this.hintergrund().add(new ImageObject("wiese.jpg"));
        this.wolken().add(new ImageObject(new Vertex(800.0, 10.0), new Vertex(-1.0, 0.0), "wolke.png"));
        this.wolken().add(new ImageObject(new Vertex(880.0, 90.0), new Vertex(-1.2, 0.0), "wolke.png"));
        this.wolken().add(new ImageObject(new Vertex(1080.0, 60.0), new Vertex(-1.1, 0.0), "wolke.png"));
        this.wolken().add(new ImageObject(new Vertex(980.0, 110.0), new Vertex(-0.9, 0.0), "wolke.png"));
        this.gegner().add(new ImageObject(new Vertex(800.0, 100.0), new Vertex(-1.0, 0.0), "biene.png"));
        this.gegner().add(new ImageObject(new Vertex(800.0, 300.0), new Vertex(-1.5, 0.0), "biene.png"));
        this.texte().add(new TextObject(new Vertex(10.0, 30.0), "Bienenstiche: 0"));
    }

    @Override
    public void doChecks() {
        for (GameObj w : this.wolken()) {
            if (!w.isLeftOf(0.0)) continue;
            w.pos().x = this.width();
        }
        for (GameObj g : this.gegner()) {
            if (g.isLeftOf(0.0)) {
                g.pos().x = this.width();
            }
            if (!this.player.touches(g)) continue;
            g.pos().moveTo(new Vertex(this.width() + 10, g.pos().y));
            this.schaden[0] = this.schaden[0] + 1;
            this.texte().clear();
            this.texte().add(new TextObject(new Vertex(10.0, 30.0), "Bienenstiche: " + this.schaden[0]));
        }
    }

    @Override
    public void keyPressedReaction(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 39: {
                this.player().velocity().add(new Vertex(1.0, 0.0));
                break;
            }
            case 37: {
                this.player().velocity().add(new Vertex(-1.0, 0.0));
                break;
            }
            case 40: {
                this.player().velocity().add(new Vertex(0.0, 1.0));
                break;
            }
            case 38: {
                this.player().velocity().add(new Vertex(0.0, -1.0));
            }
        }
    }

    @Override
    public boolean won() {
        return false;
    }

    @Override
    public boolean lost() {
        return false;
    }

    @Override
    public GameObj player() {
        return this.player;
    }

    @Override
    public List<List<? extends GameObj>> goss() {
        return this.goss;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    public int[] schaden() {
        return this.schaden;
    }

    public List<GameObj> hintergrund() {
        return this.hintergrund;
    }

    public List<GameObj> gegner() {
        return this.gegner;
    }

    public List<GameObj> wolken() {
        return this.wolken;
    }

    public List<GameObj> texte() {
        return this.texte;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{SimpleGame.class, "player;goss;width;height;schaden;hintergrund;gegner;wolken;texte", "player", "goss", "width", "height", "schaden", "hintergrund", "gegner", "wolken", "texte"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{SimpleGame.class, "player;goss;width;height;schaden;hintergrund;gegner;wolken;texte", "player", "goss", "width", "height", "schaden", "hintergrund", "gegner", "wolken", "texte"}, this);
    }

    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{SimpleGame.class, "player;goss;width;height;schaden;hintergrund;gegner;wolken;texte", "player", "goss", "width", "height", "schaden", "hintergrund", "gegner", "wolken", "texte"}, this, object);
    }

    SimpleGame(GameObj gameObj, List list, int n, int n2, int[] nArray, List list2, List list3, List list4, List list5) {
        this.player = gameObj;
        this.goss = list;
        this.width = n;
        this.height = n2;
        this.schaden = nArray;
        this.hintergrund = list2;
        this.gegner = list3;
        this.wolken = list4;
        this.texte = list5;
    }
}

