/*
 * Decompiled with CFR 0.152.
 */
package name.panitz.game2d.mygame;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import name.panitz.game2d.mygame.Schwierigkeit;
import name.panitz.game2d.mygame.Settings;
import name.panitz.game2d.mygame.StarGame;

public class WelcomeScreen
extends JFrame {
    private JPanel contentPane;

    public WelcomeScreen(final StarGame starGame, JFrame components) {
        this.setResizable(false);
        this.setTitle("Star Game");
        this.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("logo.png")).getImage());
        this.setDefaultCloseOperation(3);
        if (components != null) {
            this.setLocationRelativeTo(components);
        }
        try {
            boolean wasset = false;
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    UIManager.setLookAndFeel(info.getClassName());
                    wasset = true;
                    break;
                }
                ++n2;
            }
            if (!wasset) {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setBounds(100, 100, 420, 380);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        JButton btnNewButton_1 = new JButton("Einstellungen");
        SpringLayout sl_contentPane = new SpringLayout();
        sl_contentPane.putConstraint("North", (Component)btnNewButton_1, 237, "North", (Component)this.contentPane);
        sl_contentPane.putConstraint("West", (Component)btnNewButton_1, 197, "West", (Component)this.contentPane);
        sl_contentPane.putConstraint("South", (Component)btnNewButton_1, -10, "South", (Component)this.contentPane);
        sl_contentPane.putConstraint("East", (Component)btnNewButton_1, -10, "East", (Component)this.contentPane);
        this.contentPane.setLayout(sl_contentPane);
        JLabel lblNewLabel = new JLabel("");
        lblNewLabel.setHorizontalAlignment(0);
        lblNewLabel.setVerticalAlignment(3);
        sl_contentPane.putConstraint("North", (Component)lblNewLabel, 13, "North", (Component)this.contentPane);
        sl_contentPane.putConstraint("South", (Component)lblNewLabel, 73, "North", (Component)this.contentPane);
        sl_contentPane.putConstraint("East", (Component)lblNewLabel, -13, "East", (Component)this.contentPane);
        ImageIcon icon = new ImageIcon(this.getClass().getClassLoader().getResource("stargame-sm.png"));
        lblNewLabel.setIcon(icon);
        sl_contentPane.putConstraint("West", (Component)lblNewLabel, 10, "West", (Component)this.contentPane);
        this.contentPane.add(lblNewLabel);
        this.contentPane.add(btnNewButton_1);
        final JButton btnNewButton = new JButton("Starten");
        sl_contentPane.putConstraint("North", (Component)btnNewButton, 164, "South", (Component)lblNewLabel);
        sl_contentPane.putConstraint("West", (Component)btnNewButton, 0, "West", (Component)this.contentPane);
        sl_contentPane.putConstraint("South", (Component)btnNewButton, -10, "South", (Component)this.contentPane);
        sl_contentPane.putConstraint("East", (Component)btnNewButton, -6, "West", (Component)btnNewButton_1);
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WelcomeScreen.this.dispose();
                starGame.play(WelcomeScreen.this);
            }
        });
        this.contentPane.add(btnNewButton);
        JPanel panel = new JPanel();
        sl_contentPane.putConstraint("North", (Component)panel, 31, "South", (Component)lblNewLabel);
        sl_contentPane.putConstraint("West", (Component)panel, 0, "West", (Component)lblNewLabel);
        sl_contentPane.putConstraint("South", (Component)panel, 98, "South", (Component)lblNewLabel);
        sl_contentPane.putConstraint("East", (Component)panel, 0, "East", (Component)lblNewLabel);
        this.contentPane.add(panel);
        final JToggleButton tglbtnNewToggleButton = new JToggleButton("Easy");
        tglbtnNewToggleButton.setToolTipText("<html><p width=\"200\">- Mehr Powerups<br>- Weniger Asteroiden<br>- Viel weniger Punkte<br></p></html>");
        final JToggleButton tglbtnNewToggleButton_1 = new JToggleButton("Medium");
        tglbtnNewToggleButton_1.setToolTipText("<html><p width=\"200\">- Mittlere Menge an Powerups<br>- Mittlere Menge an Asteroiden<br>- weniger Punkte<br></p></html>");
        tglbtnNewToggleButton_1.setSelected(true);
        tglbtnNewToggleButton_1.setBackground(Color.YELLOW);
        final JToggleButton tglbtnNewToggleButton_2 = new JToggleButton("Hard");
        tglbtnNewToggleButton_2.setToolTipText("<html><p width=\"200\">- Weniger Powerups<br>- Viele Asteroiden<br>- Viele Punkte<br></p></html>");
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == tglbtnNewToggleButton) {
                    starGame.difficulty = Schwierigkeit.EASY;
                    tglbtnNewToggleButton.setSelected(true);
                    tglbtnNewToggleButton_1.setSelected(false);
                    tglbtnNewToggleButton_2.setSelected(false);
                    tglbtnNewToggleButton.setBackground(Color.GREEN);
                    tglbtnNewToggleButton_1.setBackground(null);
                    tglbtnNewToggleButton_2.setBackground(null);
                } else if (e.getSource() == tglbtnNewToggleButton_1) {
                    starGame.difficulty = Schwierigkeit.MEDIUM;
                    tglbtnNewToggleButton.setSelected(false);
                    tglbtnNewToggleButton_1.setSelected(true);
                    tglbtnNewToggleButton_2.setSelected(false);
                    tglbtnNewToggleButton.setBackground(null);
                    tglbtnNewToggleButton_1.setBackground(Color.YELLOW);
                    tglbtnNewToggleButton_2.setBackground(null);
                } else if (e.getSource() == tglbtnNewToggleButton_2) {
                    starGame.difficulty = Schwierigkeit.HARD;
                    tglbtnNewToggleButton.setSelected(false);
                    tglbtnNewToggleButton_1.setSelected(false);
                    tglbtnNewToggleButton_2.setSelected(true);
                    tglbtnNewToggleButton.setBackground(null);
                    tglbtnNewToggleButton_1.setBackground(null);
                    tglbtnNewToggleButton_2.setBackground(Color.RED);
                }
            }
        };
        tglbtnNewToggleButton.addActionListener(al);
        tglbtnNewToggleButton_1.addActionListener(al);
        tglbtnNewToggleButton_2.addActionListener(al);
        panel.setLayout(new GridLayout(0, 3, 0, 0));
        panel.add(tglbtnNewToggleButton);
        panel.add(tglbtnNewToggleButton_1);
        panel.add(tglbtnNewToggleButton_2);
        JLabel lblNewLabel_1 = new JLabel("Highscore");
        lblNewLabel_1.setCursor(Cursor.getPredefinedCursor(12));
        lblNewLabel_1.setToolTipText(Settings.onlineStartUrl);
        lblNewLabel_1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI(Settings.onlineStartUrl));
                }
                catch (IOException | URISyntaxException e1) {
                    System.out.println("Fehler beim \u00d6ffnen der URL. Bitte manuell \u00f6ffnen.");
                    System.out.println("URL: " + Settings.onlineStartUrl);
                }
            }
        });
        lblNewLabel_1.setFont(new Font("Tahoma", 0, 16));
        lblNewLabel_1.setForeground(Color.BLUE);
        sl_contentPane.putConstraint("West", (Component)lblNewLabel_1, 0, "West", (Component)lblNewLabel);
        sl_contentPane.putConstraint("South", (Component)lblNewLabel_1, -6, "North", (Component)btnNewButton);
        this.contentPane.add(lblNewLabel_1);
        btnNewButton_1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                starGame.loadProps();
                btnNewButton.setEnabled(true);
                Settings set = new Settings(starGame.getProps(), starGame);
                set.setLocationRelativeTo(WelcomeScreen.this);
                set.setVisible(true);
            }
        });
        if (starGame.getProps().size() == 0) {
            btnNewButton.setEnabled(false);
            btnNewButton.setToolTipText("Du musst vorher die Einstellungen \u00fcberpr\u00fcfen.");
        }
    }
}

