/*
 * Decompiled with CFR 0.152.
 */
package name.panitz.game2d.mygame;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import name.panitz.game2d.AbstractGameObj;
import name.panitz.game2d.AudioFilePlayer;
import name.panitz.game2d.ClickableGameObj;
import name.panitz.game2d.Game;
import name.panitz.game2d.GameObj;
import name.panitz.game2d.SwingScreen;
import name.panitz.game2d.Vertex;
import name.panitz.game2d.mygame.Asteroid;
import name.panitz.game2d.mygame.MyWindowListener;
import name.panitz.game2d.mygame.PowerUp;
import name.panitz.game2d.mygame.PowerUpType;
import name.panitz.game2d.mygame.Schwierigkeit;
import name.panitz.game2d.mygame.ScreenResulution;
import name.panitz.game2d.mygame.Settings;
import name.panitz.game2d.mygame.WelcomeScreen;

public class StarGame
implements Game {
    List<List<? extends GameObj>> goss = new ArrayList<List<? extends GameObj>>();
    public static int lastx = 0;
    public static int lasty = 0;
    Properties props = null;
    boolean isinit = false;
    AbstractGameObj player = null;
    boolean fullScreen = false;
    long gametimetracker = 0L;
    boolean ismenuopen = false;
    boolean islost = false;
    public static boolean firstOpen = true;
    public static boolean soundallowed = false;
    AudioFilePlayer musicPlayer = new AudioFilePlayer();
    Schwierigkeit difficulty = Schwierigkeit.MEDIUM;
    ArrayList<Integer> pressedKeys = new ArrayList();
    double currentScore = 0.0;
    boolean requestControlRemoval = false;
    boolean autostart = false;
    static final double fullhdpixels = 2073600.0;
    double relativetofullhd = 0.0;
    int width = 0;
    int height = 0;
    int extraLives = 0;
    boolean collectedpoints = false;
    long increaseControl = 0L;
    private WelcomeScreen wcs;
    long lastAst = 0L;
    long lastMoveCheck = 0L;
    long lastHoverCheck = 0L;
    private JFrame f = null;
    private SwingScreen sw;
    long lastPowerup = 0L;
    boolean movebonus = false;
    long invincible = 0L;
    int bonuscounter = 0;
    Vertex oldpos = new Vertex(0.0, 0.0);
    ArrayList<ClickableGameObj> ishovering = new ArrayList();
    HashMap<Long, Double> moves = new HashMap();

    private void setRes() {
        if (this.fullScreen) {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice[] gs = ge.getScreenDevices();
            int i = 0;
            while (i < gs.length) {
                if (gs[i].getIDstring().equals(this.f.getGraphicsConfiguration().getDevice().getIDstring())) {
                    this.width = gs[i].getDefaultConfiguration().getBounds().width;
                    this.height = gs[i].getDefaultConfiguration().getBounds().height;
                }
                ++i;
            }
        } else {
            this.width = ScreenResulution.values()[Integer.parseInt(this.props.getProperty("aufloesung"))].getWidth();
            this.height = ScreenResulution.values()[Integer.parseInt(this.props.getProperty("aufloesung"))].getHeight();
        }
        this.relativetofullhd = (double)(this.width * this.height) / 2073600.0;
    }

    public Properties getProps() {
        return this.props;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public GameObj player() {
        AbstractGameObj mypl;
        if (this.player != null) {
            return this.player;
        }
        final ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(new Color(255, 255, 255));
        colors.add(new Color(248, 248, 248));
        colors.add(new Color(240, 240, 240));
        colors.add(new Color(224, 224, 224));
        colors.add(new Color(192, 192, 192));
        colors.add(new Color(128, 128, 128));
        colors.add(new Color(64, 64, 64));
        colors.add(new Color(32, 32, 32));
        this.player = mypl = new AbstractGameObj(new Vertex((double)this.width() / 2.0, (double)this.height() / 10.0), new Vertex(0.0, -1.0), 2.0, 2.0){
            ArrayList<movingbackgroundStar> stars;
            boolean inited;
            Image image;
            Image deadimage;
            long died;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3);
                this.stars = new ArrayList();
                this.inited = false;
                this.image = null;
                this.deadimage = null;
                this.died = 0L;
            }

            @Override
            public void paintTo(Graphics g) {
                if (StarGame.this.islost) {
                    if (this.died == 0L) {
                        this.died = System.currentTimeMillis();
                        this.velocity = new Vertex(0.0, 0.0);
                    }
                    if (System.currentTimeMillis() - this.died < 1000L) {
                        if (this.deadimage == null) {
                            this.deadimage = new ImageIcon(this.getClass().getClassLoader().getResource("exp.png")).getImage();
                            this.deadimage = this.deadimage.getScaledInstance((int)((double)this.deadimage.getWidth(null) * 0.3), (int)((double)this.deadimage.getHeight(null) * 0.3), 4);
                        }
                        g.drawImage(this.deadimage, (int)this.pos().x - this.deadimage.getWidth(null) / 2, (int)this.pos().y - this.deadimage.getHeight(null) / 2, null);
                    }
                    return;
                }
                if (!this.inited) {
                    this.inited = true;
                    ImageIcon iIcon = new ImageIcon(this.getClass().getClassLoader().getResource("rocket-g9b2911d2e_640.png"));
                    double scale = 0.1;
                    iIcon.setImage(iIcon.getImage().getScaledInstance((int)((double)iIcon.getIconWidth() * scale), (int)((double)iIcon.getIconHeight() * scale), 4));
                    this.image = iIcon.getImage();
                }
                boolean bettercontrol = StarGame.this.increaseControl - System.currentTimeMillis() >= 0L;
                int ib = 0;
                while (ib != 4) {
                    int max;
                    int n = max = bettercontrol ? 500 : 300;
                    if (this.stars.size() < max && (this.velocity.x != 0.0 || this.velocity.y != 0.0)) {
                        Vertex v = new Vertex(this.pos.x, this.pos.y);
                        v.add(this.velocity());
                        Vertex spawnloc = new Vertex(this.pos.x, this.pos.y);
                        double xmod = Math.random() * 1.0 - 0.5;
                        double ymod = Math.random() * 1.0 - 0.5;
                        double xvmod = Math.random() * 3.0 - 1.5;
                        double yvmod = Math.random() * 3.0 - 1.5;
                        double mod = bettercontrol ? 2 : 1;
                        spawnloc.add(new Vertex(xmod * mod, ymod * mod));
                        v.add(this.velocity());
                        double speedmod = Math.random() * 0.5 + 0.5;
                        if (bettercontrol) {
                            speedmod *= 1.5;
                        }
                        Vertex v2 = new Vertex(speedmod * (spawnloc.x - v.x + xvmod), speedmod * (spawnloc.y - v.y + yvmod));
                        Color c = (Color)colors.get((int)(Math.random() * (double)colors.size()));
                        if (StarGame.this.movebonus && Math.random() > 0.8) {
                            c = Color.yellow;
                        }
                        if (bettercontrol && Math.random() > 0.8) {
                            c = Color.red;
                        }
                        this.stars.add(new movingbackgroundStar(spawnloc, v2, (long)((double)(System.currentTimeMillis() + 600L) + Math.random() * 50.0), 5, c));
                    }
                    ++ib;
                }
                ArrayList toremove = new ArrayList();
                this.stars.forEach(e -> {
                    if (e.despawntime < System.currentTimeMillis()) {
                        toremove.add(e);
                    }
                });
                this.stars.removeAll(toremove);
                for (movingbackgroundStar star : this.stars) {
                    Vertex curloc = new Vertex(star.v.x, star.v.y);
                    curloc.add(star.move);
                    int i = 0;
                    while ((long)i < 20L - (star.despawntime - System.currentTimeMillis()) / 50L) {
                        curloc.add(star.move);
                        ++i;
                    }
                    g.setColor(star.c);
                    g.fillOval((int)curloc.x, (int)curloc.y, star.size, star.size);
                }
                g.setColor(Color.red);
                double radiant = Math.atan2(this.velocity().x, -this.velocity().y);
                BufferedImage rotatedImage = new BufferedImage(this.image.getWidth(null) * 1, this.image.getHeight(null) * 1, 2);
                Graphics g2d = ((Image)rotatedImage).getGraphics();
                g2d.drawImage(this.image, 0, 0, null);
                g2d.dispose();
                AffineTransform at = new AffineTransform();
                at.rotate(radiant, (double)this.image.getWidth(null) / 2.0, (double)this.image.getHeight(null) / 2.0);
                AffineTransformOp op = new AffineTransformOp(at, 2);
                BufferedImage bi = new BufferedImage(this.image.getWidth(null) * 1, this.image.getHeight(null) * 1, 2);
                op.filter(rotatedImage, bi);
                g.drawImage(bi, (int)this.pos().x - ((Image)rotatedImage).getWidth(null) / 2, (int)this.pos().y - ((Image)rotatedImage).getHeight(null) / 2, null);
                g.setColor(Color.black);
                if (StarGame.this.invincible - System.currentTimeMillis() >= 0L) {
                    Color c = Color.cyan;
                    int dif = (int)(StarGame.this.invincible - System.currentTimeMillis());
                    g.setColor(c);
                    int degrees = (int)(360.0 - (double)dif / 7000.0 * 360.0);
                    g.drawArc((int)this.pos().x - 50, (int)this.pos().y - 50, 100, 100, degrees, 360 - degrees);
                    g.setColor(Color.blue);
                    g.drawArc((int)this.pos().x - 50, (int)this.pos().y - 50, 100, 100, 0, degrees);
                    g.setColor(Color.black);
                } else if (StarGame.this.extraLives == 1) {
                    g.setColor(Color.YELLOW);
                    g.drawOval((int)this.pos().x - 50, (int)this.pos().y - 50, 100, 100);
                }
            }

            @Override
            public void move() {
                this.pos().add(this.velocity());
                if (this.pos().x < 0.0) {
                    this.pos().x = 0.0;
                }
                if (this.pos().x > (double)StarGame.this.width()) {
                    this.pos().x = StarGame.this.width();
                }
                if (this.pos().y < 0.0) {
                    this.pos().y = 0.0;
                }
                if (this.pos().y + 50.0 > (double)StarGame.this.height()) {
                    this.pos().y = StarGame.this.height() - 50;
                    return;
                }
            }
        };
        return mypl;
    }

    @Override
    public void paintTo(Graphics g) {
        for (List<? extends GameObj> gos : this.goss()) {
            gos.forEach(go -> go.paintTo(g));
        }
    }

    @Override
    public void init() {
        if (this.isinit) {
            return;
        }
        this.isinit = true;
        this.props = this.loadProps();
        this.wcs = new WelcomeScreen(this, this.f);
        if (this.f != null) {
            this.wcs.setLocationRelativeTo(this.f);
        }
        if (this.f != null && this.sw != null) {
            this.sw.disable();
        }
        if (firstOpen && this.props.get("allowsounds") != null && this.props.get("allowsounds").equals("true")) {
            soundallowed = true;
        }
        ArrayList<GameObj> go = new ArrayList<GameObj>();
        go.add(this.player());
        this.goss.add(go);
        ArrayList asteroids = new ArrayList();
        this.goss.add(asteroids);
        ArrayList playerandotherimportant = new ArrayList();
        this.goss.add(playerandotherimportant);
        if (!this.autostart) {
            this.wcs.setVisible(true);
        }
        if (this.f != null) {
            this.f.dispose();
        }
    }

    public SwingScreen getSwingScreen() {
        return this.sw;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doChecks() {
        double speedlimit;
        double d;
        if (System.currentTimeMillis() - 50L > this.lastMoveCheck && !this.islost) {
            this.lastMoveCheck = System.currentTimeMillis();
            double dist = StarGame.distanceBetween(this.player().pos(), this.oldpos);
            this.oldpos = new Vertex(this.player().pos().x, this.player().pos().y);
            this.moves.put(System.currentTimeMillis(), dist);
            d = this.moves.values().stream().mapToDouble(Double::doubleValue).sum() / (double)this.moves.size();
            this.movebonus = d > 8.0 && this.moves.size() >= 30;
            this.moves.entrySet().removeIf(e -> (Long)e.getKey() < System.currentTimeMillis() - 3000L);
        }
        if (System.currentTimeMillis() - 50L > this.lastHoverCheck) {
            this.lastHoverCheck = System.currentTimeMillis();
            for (List<? extends GameObj> gos : this.goss()) {
                for (GameObj gameObj : gos) {
                    void clickable;
                    GameObj gameObj2 = gameObj;
                    if (!(gameObj2 instanceof ClickableGameObj)) continue;
                    ClickableGameObj cfr_ignored_0 = (ClickableGameObj)gameObj2;
                    ClickableGameObj cfr_ignored_1 = (ClickableGameObj)gameObj2;
                    Point p = this.sw.getMousePosition();
                    if (p == null) continue;
                    double x = p.getLocation().x;
                    double y = p.getLocation().y;
                    AbstractGameObj gameob = new AbstractGameObj(new Vertex(x, y), new Vertex(), 20.0, 20.0){};
                    if (gameob.touches((GameObj)clickable)) {
                        if (this.ishovering.contains(clickable)) continue;
                        this.ishovering.add((ClickableGameObj)clickable);
                        clickable.onHover();
                        continue;
                    }
                    if (!this.ishovering.contains(clickable)) continue;
                    this.ishovering.remove(clickable);
                    clickable.onStopHover();
                }
            }
        }
        if (System.currentTimeMillis() - 50L > this.lastAst && !this.islost) {
            ArrayList<GameObj> torem = new ArrayList<GameObj>();
            this.lastAst = System.currentTimeMillis();
            this.currentScore += (this.movebonus ? 1.35 : 1.0) * this.difficulty.getDifficultyScoreFactor();
            double time = System.currentTimeMillis() - this.gametimetracker;
            double base = (double)this.difficulty.getDifficultyLevel() / 4.0 + time / (36000.0 / (double)this.difficulty.getDifficultyLevel());
            if (base > 1.5 && base < 12.5) {
                base = -2.65135E-8 * Math.pow(base, 12.0) + 2.2459215E-6 * Math.pow(base, 11.0) - 8.47686104E-5 * Math.pow(base, 10.0) + 0.0018800292108 * Math.pow(base, 9.0) - 0.0272047026565 * Math.pow(base, 8.0) + 0.2696413277116 * Math.pow(base, 7.0) - 1.8695525127683 * Math.pow(base, 6.0) + 9.0942448605602 * Math.pow(base, 5.0) - 30.6362243073935 * Math.pow(base, 4.0) + 69.2474061397725 * Math.pow(base, 3.0) - 98.9169336820611 * Math.pow(base, 2.0) + 80.0368253968274 * base - 26.2000000000007;
                base = Math.max(base - 0.75, 1.5);
            } else {
                base = base > 12.5 ? 4.25 : (base -= 0.5 * (base / 1.5));
            }
            base *= this.relativetofullhd;
            ArrayList objlist = (ArrayList)this.goss().get(1);
            if (this.increaseControl - System.currentTimeMillis() >= 0L) {
                base *= 0.25;
            }
            while (base >= 0.0) {
                if (base >= 1.0 || Math.random() < base) {
                    Asteroid ob = new Asteroid(new Vertex((int)(Math.random() * (double)this.width()), 0.0), new Vertex(0.0, 0.5 + Math.random() * 4.0), 30.0, 30.0){};
                    if (!this.islost) {
                        objlist.add(ob);
                    }
                }
                base -= 1.0;
            }
            if ((double)(System.currentTimeMillis() - this.lastPowerup) > (double)(7000 - 500 * (3 - this.difficulty.getDifficultyLevel())) / (1.0 + Math.max(0.0, this.relativetofullhd - 1.0) / 2.0) && Math.random() > 0.875) {
                this.lastPowerup = System.currentTimeMillis();
                PowerUpType type = PowerUpType.values()[(int)(Math.random() * (double)PowerUpType.values().length)];
                PowerUp pu = new PowerUp(new Vertex((int)(Math.random() * (double)this.width()), 0.0), new Vertex(0.0, 0.5 + Math.random() * 4.0), 40.0, 40.0, type){
                    long last;
                    Color color;
                    boolean rewarded;
                    {
                        this.last = System.currentTimeMillis();
                        this.color = this.type.color;
                        this.rewarded = false;
                    }

                    @Override
                    public void paintTo(Graphics g) {
                        if (this.rewarded) {
                            return;
                        }
                        if (this.type == PowerUpType.UltraPowerUp && System.currentTimeMillis() - this.last > 100L) {
                            this.last = System.currentTimeMillis();
                            this.color = new Color((int)(Math.random() * 255.0), (int)(Math.random() * 255.0), (int)(Math.random() * 255.0));
                        }
                        g.setColor(this.color);
                        g.fillOval((int)this.pos().x, (int)this.pos().y, 30, 30);
                    }

                    @Override
                    public void move() {
                        super.move();
                        if (this.touches(StarGame.this.player())) {
                            if (this.rewarded) {
                                return;
                            }
                            this.rewarded = true;
                            if (soundallowed) {
                                AudioFilePlayer powerup = new AudioFilePlayer();
                                powerup.play("powerupcollect.wav", false);
                                powerup.setVolume(0.5);
                            }
                            if (this.type == PowerUpType.Control || this.type == PowerUpType.UltraPowerUp) {
                                int diff = 0;
                                if (StarGame.this.increaseControl > System.currentTimeMillis()) {
                                    diff = (int)(StarGame.this.increaseControl - System.currentTimeMillis());
                                }
                                StarGame.this.increaseControl = System.currentTimeMillis() + 13000L + (long)diff;
                                StarGame.this.requestControlRemoval = true;
                            }
                            if (this.type == PowerUpType.INVINCIBILITY || this.type == PowerUpType.UltraPowerUp) {
                                int diff = 0;
                                if (StarGame.this.invincible > System.currentTimeMillis()) {
                                    diff = (int)(StarGame.this.invincible - System.currentTimeMillis());
                                }
                                StarGame.this.invincible = System.currentTimeMillis() + 7000L + (long)diff;
                            }
                            if (this.type == PowerUpType.ExtraLife || this.type == PowerUpType.UltraPowerUp) {
                                if (StarGame.this.extraLives == 1) {
                                    this.type = PowerUpType.BONUS_POINTS;
                                } else {
                                    StarGame.this.extraLives = 1;
                                }
                            }
                            if (this.type == PowerUpType.BONUS_POINTS || this.type == PowerUpType.UltraPowerUp) {
                                StarGame.this.currentScore += (double)(100 * StarGame.this.difficulty.getDifficultyLevel());
                                StarGame.this.collectedpoints = true;
                                Timer t = new Timer();
                                t.schedule(new TimerTask(){

                                    @Override
                                    public void run() {
                                        (this).StarGame.this.collectedpoints = false;
                                    }
                                }, 2000L);
                            }
                        }
                    }
                };
                if (!this.islost) {
                    objlist.add(pu);
                }
            }
            if (this.requestControlRemoval) {
                double distancetoremove = 500.0 + (1.0 + Math.max(0.0, this.relativetofullhd - 1.0)) / 2.0;
                for (GameObj gameObj : objlist) {
                    if (!(gameObj instanceof Asteroid) || !(StarGame.distanceBetween(this.player.pos(), gameObj.pos()) < distancetoremove)) continue;
                    torem.add(gameObj);
                }
                for (GameObj gameObj : torem) {
                    objlist.remove(gameObj);
                }
                this.requestControlRemoval = false;
            }
            for (GameObj myas : objlist) {
                if (!(myas.pos().y > (double)this.height())) continue;
                torem.add(myas);
            }
            for (GameObj gameObj : torem) {
                objlist.remove(gameObj);
            }
        }
        int ym = 0;
        int xm = 0;
        if (!this.islost) {
            boolean bl;
            boolean bl2 = bl = this.pressedKeys.contains(87) || this.pressedKeys.contains(65) || this.pressedKeys.contains(83) || this.pressedKeys.contains(68);
            if (!bl) {
                if (this.pressedKeys.contains(38)) {
                    --ym;
                }
                if (this.pressedKeys.contains(40)) {
                    ++ym;
                }
                if (this.pressedKeys.contains(37)) {
                    --xm;
                }
                if (this.pressedKeys.contains(39)) {
                    ++xm;
                }
            } else {
                if (this.pressedKeys.contains(87)) {
                    --ym;
                }
                if (this.pressedKeys.contains(83)) {
                    ++ym;
                }
                if (this.pressedKeys.contains(65)) {
                    --xm;
                }
                if (this.pressedKeys.contains(68)) {
                    ++xm;
                }
            }
        }
        d = 0.0;
        double newyv = 0.0;
        double reduce = 26.0;
        if (this.increaseControl - System.currentTimeMillis() >= 0L) {
            reduce = 40.0;
        }
        newyv = ym == 0 ? this.player().velocity().y / 1.0125 : this.player().velocity().y + (double)ym * 2.0 / reduce;
        d = xm == 0 ? this.player().velocity().x / 1.0125 : this.player().velocity().x + (double)xm * 2.0 / reduce;
        if (d > (speedlimit = 2.0)) {
            d = speedlimit;
        }
        if (d < -speedlimit) {
            d = -speedlimit;
        }
        if (newyv > speedlimit) {
            newyv = speedlimit;
        }
        if (newyv < -speedlimit) {
            newyv = -speedlimit;
        }
        this.player().velocity().x = d;
        this.player().velocity().y = newyv;
        ArrayList objlist = (ArrayList)this.goss().get(1);
        boolean hit = false;
        for (GameObj myas : objlist) {
            if (!(myas instanceof Asteroid) || !myas.touches(this.player())) continue;
            hit = true;
        }
        if (this.invincible - System.currentTimeMillis() >= 0L) {
            hit = false;
        }
        if (hit) {
            if (this.extraLives == 1) {
                this.extraLives = 0;
                this.invincible = System.currentTimeMillis() + 3500L;
                return;
            }
            for (GameObj myas : objlist) {
                double y = (myas.pos().y - this.player().pos().y) / 20.0;
                double x = (myas.pos().x - this.player().pos().x) / 20.0;
                double length = Math.sqrt(x * x + y * y);
                x /= length;
                y /= length;
                myas.velocity().x = x *= 5.5 + Math.random() * 2.5;
                myas.velocity().y = y *= 5.5 + Math.random() * 2.5;
            }
            this.handleLost();
        }
    }

    @Override
    public void keyPressedReaction(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401) {
            if (this.pressedKeys.contains(keyEvent.getKeyCode())) {
                return;
            }
            this.pressedKeys.add(keyEvent.getKeyCode());
        } else if (keyEvent.getID() == 402) {
            this.pressedKeys.remove((Object)keyEvent.getKeyCode());
        }
        if (keyEvent.getID() == 401) {
            if (keyEvent.getKeyCode() == 27 && !this.ismenuopen) {
                this.openMenu();
            }
            if (keyEvent.getKeyCode() == 32 && this.islost) {
                this.handleNewGame();
            }
        }
    }

    @Override
    public boolean won() {
        return false;
    }

    @Override
    public boolean lost() {
        return false;
    }

    @Override
    @Deprecated(forRemoval=true)
    public void play() {
        throw new IllegalArgumentException("Die Playmethode darf nicht mehr verwendet werden.");
    }

    public void play(JFrame source) {
        this.f = source;
        this.init();
        this.props = this.loadProps();
        this.f = new JFrame();
        if (this.fullScreen) {
            this.f.setUndecorated(true);
        }
        this.f.setTitle("Star Game " + this.difficulty.name());
        this.f.setResizable(false);
        this.f.setDefaultCloseOperation(0);
        this.setRes();
        this.sw = new SwingScreen(this);
        this.f.add(this.sw);
        this.f.pack();
        this.f.setIconImage(new ImageIcon(this.getClass().getClassLoader().getResource("logo.png")).getImage());
        this.f.setLocationRelativeTo(null);
        this.f.addWindowListener(new MyWindowListener(this));
        AbstractGameObj score = new AbstractGameObj(new Vertex(50.0, 50.0), new Vertex(), 0.0, 0.0){

            @Override
            public void paintTo(Graphics g) {
                Color c = Color.lightGray;
                if (StarGame.this.collectedpoints) {
                    c = Color.green;
                }
                g.setColor(c);
                g.setFont(new Font("Arial", 1, 28));
                g.drawString("Score: " + (int)StarGame.this.currentScore, (int)this.pos().x, (int)this.pos().y);
            }
        };
        ClickableGameObj closebtn = new ClickableGameObj(new Vertex(this.width() - 50, 0.0), new Vertex(0.0, 0.0), 50.0, 50.0){

            @Override
            public void paintTo(Graphics g) {
                g.setColor(Color.red);
                g.fillOval(StarGame.this.width() - 50, 0, 50, 50);
                g.setColor(Color.black);
                g.setFont(new Font("Arial", 1, 20));
                Font f = g.getFont().deriveFont(1);
                FontMetrics metrics = g.getFontMetrics(f);
                Rectangle2D bounds = metrics.getStringBounds("X", g);
                double width = Math.ceil(bounds.getWidth() / 2.0);
                double height = Math.ceil(bounds.getHeight() / 2.0);
                g.setFont(f);
                g.drawString("X", (int)((double)(StarGame.this.width() - 23) - width), (int)(23.0 + height));
            }

            @Override
            public void onClick() {
                if (StarGame.this.ismenuopen) {
                    return;
                }
                StarGame.this.openMenu();
            }

            @Override
            public void onHover() {
            }

            @Override
            public void onStopHover() {
            }
        };
        ImageIcon soundon = new ImageIcon(this.getClass().getClassLoader().getResource("sound on.png"));
        ImageIcon soundoff = new ImageIcon(this.getClass().getClassLoader().getResource("sound off.png"));
        Image img = soundon.getImage();
        Image newimg = img.getScaledInstance(30, 30, 4);
        soundon = new ImageIcon(newimg);
        img = soundoff.getImage();
        newimg = img.getScaledInstance(30, 30, 4);
        soundoff = new ImageIcon(newimg);
        final Image soon = soundon.getImage();
        final Image sooff = soundoff.getImage();
        ClickableGameObj soundbtn = new ClickableGameObj(new Vertex(this.width() - 110, 0.0), new Vertex(0.0, 0.0), 50.0, 50.0){

            @Override
            public void paintTo(Graphics g) {
                Font f = new Font("SERIF", 0, 28);
                g.setFont(f);
                ImageIcon img = null;
                img = soundallowed ? new ImageIcon(soon) : new ImageIcon(sooff);
                double width = Math.ceil(img.getIconWidth() / 2);
                double height = Math.ceil(img.getIconHeight() / 2);
                g.drawImage(img.getImage(), (int)((double)(StarGame.this.width() - 87) - width), (int)height, null);
            }

            @Override
            public void onClick() {
                boolean bl = soundallowed = !soundallowed;
                if (soundallowed) {
                    StarGame.this.musicPlayer.resume();
                } else {
                    StarGame.this.musicPlayer.pause();
                }
            }

            @Override
            public void onHover() {
            }

            @Override
            public void onStopHover() {
            }
        };
        ArrayList gobs = (ArrayList)this.goss().get(2);
        gobs.add(closebtn);
        gobs.add(score);
        gobs.add(soundbtn);
        this.f.setVisible(true);
        ArrayList<MouseListener> torem = new ArrayList<MouseListener>();
        MouseListener[] mouseListenerArray = this.sw.getMouseListeners();
        int n = mouseListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            MouseListener mouseListeners = mouseListenerArray[n2];
            torem.add(mouseListeners);
            ++n2;
        }
        for (MouseListener mouseListener : torem) {
            this.sw.removeMouseListener(mouseListener);
        }
        this.sw.addMouseListener(new MouseAdapter(){
            ClickableGameObj clickab = null;

            /*
             * WARNING - void declaration
             */
            @Override
            public void mousePressed(MouseEvent e) {
                for (List<? extends GameObj> gos : StarGame.this.goss()) {
                    for (GameObj gameObj : gos) {
                        void clickable;
                        GameObj gameObj2 = gameObj;
                        if (!(gameObj2 instanceof ClickableGameObj)) continue;
                        ClickableGameObj cfr_ignored_0 = (ClickableGameObj)gameObj2;
                        ClickableGameObj cfr_ignored_1 = (ClickableGameObj)gameObj2;
                        AbstractGameObj gameob = new AbstractGameObj(new Vertex(e.getX(), e.getY()), new Vertex(), 5.0, 5.0){};
                        if (!gameob.touches((GameObj)clickable)) continue;
                        this.clickab = clickable;
                        return;
                    }
                }
                this.clickab = null;
                super.mousePressed(e);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void mouseReleased(MouseEvent e) {
                ArrayList<void> toclick = new ArrayList<void>();
                for (List<? extends GameObj> list : StarGame.this.goss()) {
                    for (GameObj gameObj : list) {
                        void clickable;
                        GameObj gameObj2 = gameObj;
                        if (!(gameObj2 instanceof ClickableGameObj)) continue;
                        ClickableGameObj cfr_ignored_0 = (ClickableGameObj)gameObj2;
                        ClickableGameObj cfr_ignored_1 = (ClickableGameObj)gameObj2;
                        AbstractGameObj gameob = new AbstractGameObj(new Vertex(e.getX(), e.getY()), new Vertex(), 5.0, 5.0){};
                        if (!gameob.touches((GameObj)clickable) || this.clickab == null || this.clickab != clickable) continue;
                        toclick.add(clickable);
                    }
                }
                for (ClickableGameObj clickableGameObj : toclick) {
                    clickableGameObj.onClick();
                }
            }
        });
        AbstractGameObj background = new AbstractGameObj(new Vertex(0.0, 0.0), new Vertex(), this.width(), this.height()){
            Color c;
            ArrayList<backgroundStar> starswithduration;
            {
                this.c = new Color(17, 17, 34);
                this.starswithduration = new ArrayList();
            }

            @Override
            public void paintTo(Graphics g) {
                double repeat = StarGame.this.relativetofullhd * 2.0;
                while (repeat > 0.0) {
                    if (Math.random() < repeat) {
                        Vertex pos = new Vertex((int)(Math.random() * this.width()), (int)(Math.random() * this.height()));
                        backgroundStar star = new backgroundStar(pos, System.currentTimeMillis() + 500L + Math.round(Math.random() * 8000.0), 2 + (int)(Math.random() * 2.0), Color.WHITE);
                        this.starswithduration.add(star);
                    }
                    repeat -= 1.0;
                }
                this.starswithduration.removeIf(e -> e.despawntime < System.currentTimeMillis());
                g.setColor(this.c);
                g.fillRect(0, 0, (int)this.width(), (int)this.height());
                for (backgroundStar mystar : this.starswithduration) {
                    g.setColor(Color.WHITE);
                    g.fillOval((int)mystar.v.x, (int)mystar.v.y, mystar.size, mystar.size);
                }
            }
        };
        ArrayList gos = (ArrayList)this.goss().get(0);
        gos.add(0, background);
        this.gametimetracker = System.currentTimeMillis();
        this.musicPlayer.play("space.wav", true);
        this.musicPlayer.setVolume(0.8f);
        this.player().pos().x = (double)this.width() / 2.0;
        this.player().pos().y = (double)this.height() - (double)this.height() / 10.0;
        if (!soundallowed) {
            this.musicPlayer.pause();
        }
        firstOpen = false;
    }

    public Properties loadProps() {
        Properties prop = new Properties();
        File f = new File(String.valueOf(System.getProperty("user.home")) + "/.stargame.conf");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileReader myfr = new FileReader(f);){
                prop.load(myfr);
                this.props = prop;
                this.fullScreen = this.props.get("fenstermode").equals("true");
                return prop;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return prop;
        }
    }

    public void openMenu() {
        this.musicPlayer.setVolume(0.1);
        this.ismenuopen = true;
        long currenttime = System.currentTimeMillis();
        this.sw.getTimer().stop();
        Thread t = new Thread(() -> {
            Object[] options = new String[]{"Spiel beenden", "Weiterspielen", "Hauptmen\u00fc"};
            int choice = JOptionPane.showOptionDialog(this.f, "Was m\u00f6chten Sie tun?", "Men\u00fc", -1, 1, null, options, options[1]);
            if (choice == 0) {
                System.exit(0);
            }
            if (choice == 2) {
                this.musicPlayer.stop();
                this.sw.disable();
                StarGame.handleDMenu(this.f, Schwierigkeit.MEDIUM, false);
            }
            if (soundallowed) {
                this.musicPlayer.setVolume(0.8f);
            }
            this.gametimetracker += System.currentTimeMillis() - currenttime;
            this.ismenuopen = false;
            javax.swing.Timer ti = this.sw.getTimer();
            if (ti != null) {
                ti.start();
            }
        });
        t.start();
    }

    public static void main(String[] args) {
        StarGame.handleDMenu(null, Schwierigkeit.MEDIUM, false);
    }

    public static void handleDMenu(JFrame f, Schwierigkeit s, boolean autostart) {
        StarGame st = new StarGame();
        st.f = f;
        st.autostart = autostart;
        st.init();
        if (autostart) {
            st.difficulty = s;
            st.play(st.wcs);
            if (lastx != 0 && lasty != 0 && !st.fullScreen) {
                st.f.setLocation(lastx, lasty);
            }
            st.wcs.dispose();
        }
    }

    public void handleLost() {
        if (this.islost) {
            return;
        }
        try {
            this.transferScoreToOnlineLeaderboard();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (soundallowed) {
            AudioFilePlayer v = new AudioFilePlayer();
            v.play("hq-explosion-6288.wav", false);
            v.setVolume(0.4);
        }
        this.islost = true;
        final ArrayList<String> texts = new ArrayList<String>();
        texts.add("Gameover");
        AbstractGameObj text = new AbstractGameObj(new Vertex(this.width() / 2, this.height() / 2), new Vertex(), 1.0, 1.0){
            int chars;
            long lastupdate;
            int curtext;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3);
                this.chars = 0;
                this.lastupdate = 0L;
                this.curtext = 0;
            }

            @Override
            public void paintTo(Graphics g) {
                if (System.currentTimeMillis() - this.lastupdate > 150L && this.chars < ((String)texts.get(this.curtext)).length()) {
                    ++this.chars;
                    this.lastupdate = System.currentTimeMillis();
                }
                String todis = ((String)texts.get(this.curtext)).substring(0, this.chars);
                if (this.chars == ((String)texts.get(this.curtext)).length() && System.currentTimeMillis() - this.lastupdate > 1400L) {
                    this.chars = 0;
                    ++this.curtext;
                    if (this.curtext >= texts.size()) {
                        --this.curtext;
                        this.chars = ((String)texts.get(this.curtext)).length();
                    }
                    this.lastupdate = System.currentTimeMillis();
                }
                g.setColor(Color.RED);
                g.setFont(new Font("Arial", 1, 70));
                double x = this.pos().x - (double)(g.getFontMetrics().stringWidth(todis) / 2);
                double y = this.pos().y + (double)(g.getFontMetrics().getHeight() / 2);
                g.drawString(todis, (int)x, (int)y);
            }
        };
        ArrayList objlist = (ArrayList)this.goss().get(0);
        objlist.add(text);
        final String todis = "Neustart";
        this.f.setFont(new Font("Arial", 1, 70));
        double x = this.f.getGraphics().getFontMetrics().stringWidth(todis);
        double y = this.f.getGraphics().getFontMetrics().getHeight();
        ClickableGameObj replay = new ClickableGameObj(new Vertex((double)(this.sw.getWidth() / 2) - x / 2.0, this.sw.getHeight() / 2 + 130), new Vertex(), x, y){
            boolean hover;
            long created;
            long lastinteraction;
            {
                super($anonymous0, $anonymous1, $anonymous2, $anonymous3);
                this.hover = false;
                this.created = System.currentTimeMillis();
                this.lastinteraction = System.currentTimeMillis();
            }

            @Override
            public void paintTo(Graphics g) {
                if (System.currentTimeMillis() - this.created < 1700L) {
                    return;
                }
                Color c = Color.RED;
                if (this.hover) {
                    c = Color.GREEN;
                    this.lastinteraction = System.currentTimeMillis();
                }
                if (System.currentTimeMillis() - this.lastinteraction > 5000L) {
                    c = Math.ceil((System.currentTimeMillis() - this.lastinteraction) / 1500L) % 2.0 == 1.0 ? new Color(100, 0, 0) : Color.RED;
                }
                g.setFont(new Font("Arial", 1, 70));
                FontMetrics metrics = g.getFontMetrics(g.getFont());
                Rectangle2D bounds = metrics.getStringBounds(todis, g);
                double height = Math.ceil(bounds.getHeight());
                g.setColor(c);
                g.drawString(todis, (int)this.pos.x, (int)((double)((int)this.pos.y) + height / 2.0));
            }

            @Override
            public void onClick() {
                StarGame.this.handleNewGame();
            }

            @Override
            public void onHover() {
                this.hover = true;
                StarGame.this.sw.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void onStopHover() {
                this.hover = false;
                StarGame.this.sw.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        objlist.add(replay);
    }

    protected void handleNewGame() {
        lastx = this.f.getX();
        lasty = this.f.getY();
        this.musicPlayer.stop();
        this.sw.disable();
        StarGame.handleDMenu(this.f, this.difficulty, true);
    }

    @Override
    public List<List<? extends GameObj>> goss() {
        return this.goss;
    }

    public void transferScoreToOnlineLeaderboard() throws IOException {
        if (!this.props.getProperty("allowhighscore").equals("true")) {
            System.out.println("Highscore not allowed");
            return;
        }
        if (this.currentScore < 400.0 * this.difficulty.getDifficultyScoreFactor()) {
            System.out.println("Highscore too bad to be transferred");
            return;
        }
        System.out.println("Highscore allowed");
        String url = Settings.onlineUrl;
        String title = Settings.titles[Integer.parseInt(this.props.getProperty("title"))];
        String name = this.props.getProperty("nickname");
        String score = String.valueOf((int)this.currentScore);
        String dif = this.difficulty.name();
        long time = new Date().getTime();
        String uuid = this.props.getProperty("deviceid");
        String json = "{ \"title\":\"%s\",\"nickname\":\"%s\",\"score\":\"%s\",\"difficulty\":\"%s\",\"date\":\"%s\",\"deviceid\":\"%s\"}\n";
        json = String.format(json, title, name, score, dif, time, uuid);
        System.out.println(json);
        final URL obj = new URL(url);
        final String body = json;
        Thread th = new Thread(){

            @Override
            public void run() {
                block26: {
                    try {
                        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
                        con.setRequestMethod("POST");
                        con.setRequestProperty("Content-Type", "application/json");
                        con.setDoOutput(true);
                        try {
                            Throwable throwable = null;
                            Object var3_6 = null;
                            try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
                                wr.writeBytes(body);
                                wr.flush();
                                wr.close();
                                int responseCode = con.getResponseCode();
                                if (responseCode != 200) {
                                    try {
                                        Throwable throwable2 = null;
                                        Object var7_13 = null;
                                        try (BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));){
                                            String inputLine;
                                            StringBuffer response = new StringBuffer();
                                            while ((inputLine = in.readLine()) != null) {
                                                response.append(inputLine);
                                            }
                                            in.close();
                                            System.out.println(response.toString());
                                            System.out.println("Highscore transfered");
                                            break block26;
                                        }
                                        catch (Throwable throwable3) {
                                            if (throwable2 == null) {
                                                throwable2 = throwable3;
                                            } else if (throwable2 != throwable3) {
                                                throwable2.addSuppressed(throwable3);
                                            }
                                            throw throwable2;
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                    break block26;
                                }
                                System.out.println(responseCode);
                                System.out.println("Highscore not transfered");
                            }
                            catch (Throwable throwable4) {
                                if (throwable == null) {
                                    throwable = throwable4;
                                } else if (throwable != throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        th.start();
    }

    public static double distanceBetween(Vertex a, Vertex b) {
        return Math.sqrt(Math.pow(a.x - b.x, 2.0) + Math.pow(a.y - b.y, 2.0));
    }

    record backgroundStar(Vertex v, long despawntime, int size, Color c) {
    }

    record movingbackgroundStar(Vertex v, Vertex move, long despawntime, int size, Color c) {
    }
}

