/*
 * Decompiled with CFR 0.152.
 */
package name.panitz.game2d.mygame;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import name.panitz.game2d.mygame.ScreenResulution;
import name.panitz.game2d.mygame.StarGame;

public class Settings
extends JDialog {
    private JPanel contentPane;
    private JTextField nichname_textfield;
    public static String onlineUrl = "https://stargame.nkwebservices.de/api/userDatas";
    public static String onlineStartUrl = "https://stargame.nkwebservices.de/";
    public static final String[] titles = new String[]{"Commander", "Captain", "Admiral", "Colonel", "Major", "Leutnant", "Sergeant", "Corporal", "Pilot", "Astronaut", "Cosmonaut", "Mission specialist", "Space station commander", "Space shuttle commander", "Spacecraft engineer", "Space station engineer", "Planetary scientist", "Professor", "Doktor", "CFO", "CEO", "Lord"};

    public Settings(Properties prop, final StarGame starGame) {
        this.setModal(true);
        this.setResizable(false);
        this.setTitle("Einstellungen");
        this.setBounds(100, 100, 700, 800);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        final JCheckBox allowhighscore = new JCheckBox("An Highscore teilnehmen");
        allowhighscore.setBounds(6, 326, 247, 23);
        this.contentPane.add(allowhighscore);
        if (prop.containsKey("allowhighscore") && prop.getProperty("allowhighscore").equals("true")) {
            allowhighscore.setSelected(true);
        }
        JLabel lblNewLabel = new JLabel("Einstellungen");
        lblNewLabel.setBounds(15, 31, 237, 14);
        this.contentPane.add(lblNewLabel);
        this.nichname_textfield = new JTextField();
        this.nichname_textfield.setToolTipText("Ihr Spitzname oder echter Name");
        this.nichname_textfield.setFont(new Font("Arial", 0, 12));
        this.nichname_textfield.setBounds(103, 85, 149, 24);
        this.nichname_textfield.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                Settings.this.validateName();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.nichname_textfield.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                super.keyTyped(e);
                Settings.this.validateName();
            }
        });
        if (prop.containsKey("nickname") && prop.getProperty("nickname").length() != 0) {
            this.nichname_textfield.setText(prop.getProperty("nickname"));
        } else {
            String username = System.getProperty("user.name");
            username = String.valueOf(username.substring(0, 1).toUpperCase()) + username.substring(1);
            int firstUppercaseIndex = -1;
            int i = 0;
            while (i < username.length()) {
                if (Character.isUpperCase(username.charAt(i))) {
                    firstUppercaseIndex = i;
                    break;
                }
                ++i;
            }
            if (firstUppercaseIndex > 0) {
                username = username.substring(0, firstUppercaseIndex);
            }
            this.nichname_textfield.setText(username);
        }
        this.contentPane.add(this.nichname_textfield);
        this.nichname_textfield.setColumns(10);
        JLabel lblIchHeie = new JLabel("Mein Titel");
        lblIchHeie.setBounds(15, 60, 78, 14);
        this.contentPane.add(lblIchHeie);
        final JComboBox<String> title_combobox = new JComboBox<String>();
        title_combobox.setMaximumRowCount(10);
        title_combobox.setBounds(103, 60, 149, 20);
        this.contentPane.add(title_combobox);
        title_combobox.setModel(new DefaultComboBoxModel<String>(titles));
        if (prop.containsKey("title")) {
            try {
                title_combobox.setSelectedIndex(Integer.parseInt(prop.getProperty("title")));
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        JLabel lblNewLabel_1 = new JLabel("Mein Name");
        lblNewLabel_1.setBounds(15, 85, 78, 14);
        this.contentPane.add(lblNewLabel_1);
        JPanel panel = new JPanel();
        panel.setBounds(16, 356, 590, 221);
        this.contentPane.add(panel);
        panel.setLayout(new CardLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        panel.add((Component)scrollPane, "name_21691045316300");
        final JTextArea txtrDarfDasSpiel = new JTextArea();
        String datarules = "Darf das Spiel eine Verbindung zu \"https://stargame.nkwebservices.de\"\r\naufbauen, um Ihren Highscore zu ver\u00f6ffentlichen?\nDabei werden folgende Daten \u00fcbertragen:\n - IP Adresse\n - Ihr Titel\n - Ihr Spitzname\n - Schwierigkeitsstufe\n - Score\n - Datum und Uhrzeit\n - Browser Agent String\n - DeviceID (UUID)\n";
        txtrDarfDasSpiel.setText(datarules.replace("\n\n", "\n"));
        txtrDarfDasSpiel.setEditable(false);
        scrollPane.setViewportView(txtrDarfDasSpiel);
        final JSlider slider = new JSlider();
        slider.setValue(12);
        slider.setMinimum(7);
        slider.setMaximum(48);
        slider.setBounds(11, 624, 212, 26);
        this.contentPane.add(slider);
        final JLabel schriftsize = new JLabel("Schriftgr\u00f6\u00dfe: 12px");
        schriftsize.setBounds(11, 599, 212, 14);
        this.contentPane.add(schriftsize);
        JLabel lblNewLabel_1_1 = new JLabel("Sounds");
        lblNewLabel_1_1.setBounds(16, 110, 78, 14);
        this.contentPane.add(lblNewLabel_1_1);
        final JCheckBox allowsound = new JCheckBox("Sounds erlauben");
        allowsound.setBounds(103, 110, 149, 14);
        if (prop.containsKey("allowsounds") && prop.getProperty("allowsounds").equals("true")) {
            allowsound.setSelected(true);
        }
        this.contentPane.add(allowsound);
        JLabel lblNewLabel_1_1_1 = new JLabel("Aufl\u00f6sung");
        lblNewLabel_1_1_1.setBounds(15, 135, 78, 14);
        this.contentPane.add(lblNewLabel_1_1_1);
        final JComboBox<ScreenResulution> res_combobox = new JComboBox<ScreenResulution>();
        res_combobox.setModel(new DefaultComboBoxModel<ScreenResulution>(ScreenResulution.values()));
        if (prop.containsKey("aufloesung")) {
            try {
                res_combobox.setSelectedIndex(Integer.parseInt(prop.getProperty("aufloesung")));
            }
            catch (Exception exception) {}
        } else {
            res_combobox.setSelectedIndex(5);
        }
        res_combobox.setBounds(103, 131, 150, 22);
        this.contentPane.add(res_combobox);
        JLabel lblNewLabel_1_1_1_1 = new JLabel("Fensterlos");
        lblNewLabel_1_1_1_1.setBounds(15, 160, 78, 14);
        this.contentPane.add(lblNewLabel_1_1_1_1);
        final JCheckBox ohnefensterramen_chb = new JCheckBox("Vollbildmodus");
        ohnefensterramen_chb.setBounds(103, 156, 150, 23);
        this.contentPane.add(ohnefensterramen_chb);
        JButton btnNewButton = new JButton("Speichern");
        btnNewButton.setBounds(10, 296, 95, 23);
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.out.println("Saving...");
                Properties prop = new Properties();
                prop.setProperty("title", String.valueOf(title_combobox.getSelectedIndex()));
                prop.setProperty("nickname", Settings.this.nichname_textfield.getText().substring(0, Math.min(20, Settings.this.nichname_textfield.getText().length())));
                prop.setProperty("allowsounds", String.valueOf(allowsound.isSelected()));
                prop.setProperty("fenstermode", String.valueOf(ohnefensterramen_chb.isSelected()));
                prop.setProperty("allowhighscore", String.valueOf(allowhighscore.isSelected()));
                prop.setProperty("aufloesung", String.valueOf(res_combobox.getSelectedIndex()));
                if (prop.getProperty("deviceid") == null) {
                    prop.setProperty("deviceid", UUID.randomUUID().toString());
                }
                File f = new File(String.valueOf(System.getProperty("user.home")) + "/.stargame.conf");
                try {
                    prop.store(new FileWriter(f), "");
                    starGame.props = prop;
                }
                catch (IOException e1) {
                    JOptionPane.showMessageDialog(Settings.this, "Speichern fehlgeschlagen. Bitte pr\u00fcfen Sie die Berechtigungen bei " + f.getAbsolutePath() + " f\u00fcr " + System.getProperty("user.name"));
                }
                Settings.this.dispose();
            }
        });
        this.contentPane.add(btnNewButton);
        if (prop.containsKey("fenstermode") && prop.getProperty("fenstermode").equals("true")) {
            ohnefensterramen_chb.setSelected(true);
        } else if (!prop.containsKey("fenstermode")) {
            ohnefensterramen_chb.setSelected(true);
        }
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Font f = txtrDarfDasSpiel.getFont();
                txtrDarfDasSpiel.setFont(new Font(f.getFontName(), f.getStyle(), slider.getValue()));
                schriftsize.setText("Schriftgr\u00f6\u00dfe: " + slider.getValue() + "px");
            }
        });
    }

    public void validateName() {
        String text = this.nichname_textfield.getText();
        int carret = this.nichname_textfield.getCaretPosition();
        if (text.length() >= 16) {
            text = text.substring(0, 16);
            this.nichname_textfield.setText(text);
        }
        text = text.replaceAll("[^0-9A-Za-z\\s]", "");
        this.nichname_textfield.setText(text);
        this.nichname_textfield.setCaretPosition(Math.min(this.nichname_textfield.getText().length(), carret));
    }

    public void saveSettings() {
    }
}

