/*
 * Decompiled with CFR 0.152.
 */
package name.panitz.game2d.mygame;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.util.ArrayList;
import name.panitz.game2d.AbstractGameObj;
import name.panitz.game2d.Vertex;

public class Asteroid
extends AbstractGameObj {
    private int minRadius;
    private int maxRadius;
    private int granularity;
    private int tau;
    private int offset;
    private ArrayList<Vertex> points;
    private Color color;

    public Asteroid(Vertex p, Vertex v, double w, double h) {
        super(p, v, w, h);
        this.minRadius = (int)(this.width * 0.8);
        this.maxRadius = (int)(this.width * 1.3);
        this.granularity = 15;
        this.tau = 6;
        double increment = (double)this.tau / (double)this.granularity;
        this.points = new ArrayList();
        this.offset = this.maxRadius;
        double ang = 0.0;
        while (ang < (double)this.tau) {
            int radius = this.getRandom(this.minRadius, this.maxRadius);
            int x = this.offset + (int)(Math.sin(ang) * (double)radius);
            int y = this.offset + (int)(Math.cos(ang) * (double)radius);
            this.points.add(new Vertex(x, y));
            ang += increment;
        }
        int r = this.getRandom(50, 100) + 50;
        this.color = new Color(r, r, r);
        this.points.add(this.points.get(0));
    }

    private int getRandom(int min, int max) {
        return (int)(Math.floor(Math.random() * (double)(max - min)) + (double)min);
    }

    @Override
    public void paintTo(Graphics g) {
        g.setColor(this.color);
        Polygon poly = new Polygon();
        for (Vertex p : this.points) {
            poly.addPoint((int)(this.pos.x + p.x / 2.0), (int)(this.pos.y + p.y / 2.0));
        }
        g.fillPolygon(poly);
    }
}

