/*
 * Decompiled with CFR 0.152.
 */
package name.panitz.game2d.klaus;

import java.awt.event.KeyEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import name.panitz.game2d.FallingImage;
import name.panitz.game2d.Game;
import name.panitz.game2d.GameObj;
import name.panitz.game2d.ImageObject;
import name.panitz.game2d.TextObject;
import name.panitz.game2d.Vertex;
import name.panitz.game2d.klaus.Barrel;
import name.panitz.game2d.klaus.Klaus;

public final class HeartsOfKlaus
extends Record
implements Game {
    private final FallingImage player;
    private final int width;
    private final int height;
    private final List<List<? extends GameObj>> goss;
    private final List<ImageObject> walls;
    private final List<ImageObject> hearts;
    private final List<FallingImage> barrels;
    private final List<TextObject> texts;
    private final int[] energyAndHearts;
    static final int GRID_WIDTH = 34;
    static String level1 = "w                 f  w\nwhf       wwh    www w\nwwwww       ww       w\nw        h           w\nw       ww         h w\nw            ww      w\nw      hf          fhw\nw    wwww        wwwww\nw                    w\nwh             h     w\nwwwww       wwww     w\nw                    w\nw p    h            hw\nw   wwww        wwwwww\nw                    w\nw                   gw\nwwwwwwww  wwwwwwwwwwww";

    static ImageObject newHeart(Vertex corner) {
        return new ImageObject(corner, new Vertex(0.0, 0.0), "heart.png");
    }

    static ImageObject newWall(Vertex corner) {
        return new ImageObject(corner, new Vertex(0.0, 0.0), "wall.png");
    }

    public HeartsOfKlaus() {
        this(new Klaus(new Vertex(0.0, 0.0)), 748, 578, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), new int[2]);
        this.init();
    }

    private void decreaseEnergy() {
        this.energyAndHearts[0] = this.energyAndHearts[0] - 1;
        this.initTexts();
    }

    private void playerBarrelCollision() {
        for (FallingImage b : this.barrels()) {
            if (b.touches(this.player)) {
                this.decreaseEnergy();
                b.pos().moveTo(new Vertex(Math.random() * (double)(this.width() - 80) + 40.0, -40.0));
            }
            if (!(b.pos().y > (double)this.height())) continue;
            b.pos().moveTo(new Vertex(Math.random() * (double)(this.width() - 80) + 40.0, -40.0));
        }
    }

    private void fallingBarrel() {
        for (FallingImage b : this.barrels) {
            for (ImageObject wall : this.walls) {
                if (b.isAbove(wall) || b.isUnderneath(wall) || !(b.isLeftOf(wall) && b.pos().x + b.width() + b.velocity().x + 1.0 > wall.pos().x) && (!b.isRightOf(wall) || !(b.pos().x + b.velocity().x - 1.0 < wall.pos().x + wall.width()))) continue;
                b.velocity().x *= -1.0;
            }
            boolean isStandingOnTop = false;
            for (ImageObject wall : this.walls) {
                if (!b.isStandingOnTopOf(wall)) continue;
                isStandingOnTop = true;
                break;
            }
            if (!isStandingOnTop && !b.isJumping) {
                b.startJump(0.1);
                continue;
            }
            if (!isStandingOnTop) continue;
            b.restart();
        }
    }

    private void checkPlayerWallCollsions() {
        boolean isStandingOnTop = false;
        for (ImageObject wall : this.walls) {
            if (this.player.touches(wall)) {
                this.player.stop();
                return;
            }
            if (!this.player.isStandingOnTopOf(wall)) continue;
            isStandingOnTop = true;
        }
        if (!isStandingOnTop && !this.player.isJumping) {
            this.player.startJump(0.05);
        }
    }

    private void collectHearts() {
        ImageObject removeMe = null;
        for (ImageObject heart : this.hearts) {
            if (!this.player().touches(heart)) continue;
            removeMe = heart;
            this.energyAndHearts[1] = this.energyAndHearts[1] + 1;
            this.initTexts();
            break;
        }
        if (removeMe != null) {
            this.hearts.remove(removeMe);
        }
    }

    @Override
    public void doChecks() {
        this.collectHearts();
        this.checkPlayerWallCollsions();
        this.fallingBarrel();
        this.playerBarrelCollision();
        if (this.player().pos().y > (double)this.height()) {
            this.player().pos().moveTo(new Vertex(68.0, this.height() - 80));
        }
    }

    @Override
    public boolean lost() {
        return this.energyAndHearts[0] <= 0;
    }

    @Override
    public boolean won() {
        return this.hearts.isEmpty();
    }

    @Override
    public void init() {
        this.barrels.clear();
        this.hearts.clear();
        this.walls.clear();
        this.readLevel();
        this.initTexts();
        this.goss().add(this.barrels);
        this.goss().add(this.walls);
        this.goss().add(this.hearts);
        this.goss().add(this.texts);
        this.energyAndHearts[0] = 10;
        this.energyAndHearts[1] = 0;
    }

    private void readLevel() {
        String[] lines;
        int l = 0;
        String[] stringArray = lines = level1.split("\\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            int col = 0;
            char[] cArray = line.toCharArray();
            int n3 = cArray.length;
            int n4 = 0;
            while (n4 < n3) {
                char c = cArray[n4];
                switch (c) {
                    case 'w': {
                        this.walls.add(HeartsOfKlaus.newWall(new Vertex(col * 34, l * 34)));
                        break;
                    }
                    case 'h': {
                        this.hearts.add(HeartsOfKlaus.newHeart(new Vertex(col * 34, l * 34)));
                        break;
                    }
                    case 'f': {
                        this.barrels.add(new Barrel(new Vertex(col * 34, l * 34 - 1)));
                        break;
                    }
                    case 'p': {
                        this.player().pos().moveTo(new Vertex(col * 34, l * 34 - 2));
                    }
                }
                ++col;
                ++n4;
            }
            ++l;
            ++n2;
        }
    }

    private void initTexts() {
        this.texts.clear();
        this.texts.add(new TextObject(new Vertex(50.0, 20.0), "Energy: " + this.energyAndHearts[0]));
        this.texts.add(new TextObject(new Vertex(50.0, 50.0), "Hearts: " + this.energyAndHearts[1]));
    }

    @Override
    public void keyPressedReaction(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 39: {
                this.player().right();
                break;
            }
            case 37: {
                this.player().left();
                break;
            }
            case 40: {
                this.player().stop();
                break;
            }
            case 38: {
                this.player().jump();
            }
        }
    }

    @Override
    public FallingImage player() {
        return this.player;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    @Override
    public List<List<? extends GameObj>> goss() {
        return this.goss;
    }

    public List<ImageObject> walls() {
        return this.walls;
    }

    public List<ImageObject> hearts() {
        return this.hearts;
    }

    public List<FallingImage> barrels() {
        return this.barrels;
    }

    public List<TextObject> texts() {
        return this.texts;
    }

    public int[] energyAndHearts() {
        return this.energyAndHearts;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{HeartsOfKlaus.class, "player;width;height;goss;walls;hearts;barrels;texts;energyAndHearts", "player", "width", "height", "goss", "walls", "hearts", "barrels", "texts", "energyAndHearts"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{HeartsOfKlaus.class, "player;width;height;goss;walls;hearts;barrels;texts;energyAndHearts", "player", "width", "height", "goss", "walls", "hearts", "barrels", "texts", "energyAndHearts"}, this);
    }

    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{HeartsOfKlaus.class, "player;width;height;goss;walls;hearts;barrels;texts;energyAndHearts", "player", "width", "height", "goss", "walls", "hearts", "barrels", "texts", "energyAndHearts"}, this, object);
    }

    public HeartsOfKlaus(FallingImage fallingImage, int n, int n2, List list, List list2, List list3, List list4, List list5, int[] nArray) {
        this.player = fallingImage;
        this.width = n;
        this.height = n2;
        this.goss = list;
        this.walls = list2;
        this.hearts = list3;
        this.barrels = list4;
        this.texts = list5;
        this.energyAndHearts = nArray;
    }
}

