/*
 * Decompiled with CFR 0.152.
 */
package name.panitz.game2d.corona;

import java.awt.Color;
import java.awt.Graphics;
import name.panitz.game2d.AbstractGameObj;
import name.panitz.game2d.Vertex;

class Person
extends AbstractGameObj {
    public Status status = Status.ungeimpft;
    public int restInfektionnsDauer;

    Person(Vertex pos) {
        super(pos, new Vertex(Math.random() - 0.7, Math.random() - 0.7), 10.0, 10.0);
        if (Math.random() < 0.03) {
            this.infizieren();
        }
    }

    @Override
    public void paintTo(Graphics g) {
        g.setColor(this.status.c);
        g.fillRect((int)this.pos().x, (int)this.pos().y, (int)this.width(), (int)this.height());
    }

    void impfen() {
        if (this.status == Status.ungeimpft) {
            this.status = Status.geimpft;
        }
    }

    void infizieren() {
        if (this.status == Status.ungeimpft) {
            this.status = Status.infiziert;
            this.restInfektionnsDauer = 800;
        }
    }

    void genesen() {
        if (this.status == Status.infiziert) {
            if (Math.random() < 0.02) {
                this.status = Status.gestorben;
                this.velocity = new Vertex(0.0, 0.0);
            } else {
                this.status = Status.genesen;
            }
            this.restInfektionnsDauer = 0;
        }
    }

    static enum Status {
        ungeimpft(Color.BLUE),
        geimpft(Color.GREEN),
        infiziert(Color.RED),
        genesen(Color.ORANGE),
        gestorben(Color.BLACK);

        Color c;

        private Status(Color c) {
            this.c = c;
        }
    }
}

