/*
 * Decompiled with CFR 0.152.
 */
package name.panitz.game2d.corona;

import java.awt.event.KeyEvent;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import name.panitz.game2d.Game;
import name.panitz.game2d.GameObj;
import name.panitz.game2d.ImageObject;
import name.panitz.game2d.Vertex;
import name.panitz.game2d.corona.Person;

final class Corona
extends Record
implements Game {
    private final GameObj player;
    private final List<List<? extends GameObj>> goss;
    private final int width;
    private final int height;
    private final List<Person> personen;

    Corona() {
        this(new ImageObject(new Vertex(200.0, 200.0), new Vertex(0.0, 0.0), "spritze.png"), new ArrayList(), 1200, 700, new ArrayList());
    }

    @Override
    public void init() {
        this.goss().clear();
        this.personen().clear();
        this.goss.add(this.personen());
        int i = 0;
        while (i < 500) {
            this.personen().add(new Person(new Vertex(Math.random() * (double)(this.width() - 20), Math.random() * (double)(this.height() - 20))));
            ++i;
        }
    }

    @Override
    public void keyPressedReaction(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 39: {
                this.player().velocity().add(new Vertex(0.2, 0.0));
                break;
            }
            case 37: {
                this.player().velocity().add(new Vertex(-0.2, 0.0));
                break;
            }
            case 40: {
                this.player().velocity().add(new Vertex(0.0, 0.2));
                break;
            }
            case 38: {
                this.player().velocity().add(new Vertex(0.0, -0.2));
            }
        }
    }

    @Override
    public void doChecks() {
        for (Person m1 : this.personen()) {
            if (m1.pos().x < 0.0 || m1.pos().x + m1.width() > (double)this.width()) {
                m1.velocity().x *= -1.0;
            }
            if (m1.pos().y < 0.0 || m1.pos().y + m1.height() > (double)this.height()) {
                m1.velocity().y *= -1.0;
            }
            if (m1.touches(this.player())) {
                m1.impfen();
            }
            if (m1.status == Person.Status.infiziert) {
                --m1.restInfektionnsDauer;
                if (m1.restInfektionnsDauer == 0) {
                    m1.genesen();
                }
            }
            for (Person m2 : this.personen()) {
                if (!m1.touches(m2) || m1.status != Person.Status.infiziert) continue;
                m2.infizieren();
            }
        }
    }

    @Override
    public boolean won() {
        return false;
    }

    @Override
    public boolean lost() {
        return false;
    }

    @Override
    public GameObj player() {
        return this.player;
    }

    @Override
    public List<List<? extends GameObj>> goss() {
        return this.goss;
    }

    @Override
    public int width() {
        return this.width;
    }

    @Override
    public int height() {
        return this.height;
    }

    public List<Person> personen() {
        return this.personen;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{Corona.class, "player;goss;width;height;personen", "player", "goss", "width", "height", "personen"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Corona.class, "player;goss;width;height;personen", "player", "goss", "width", "height", "personen"}, this);
    }

    @Override
    public final boolean equals(Object object) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Corona.class, "player;goss;width;height;personen", "player", "goss", "width", "height", "personen"}, this, object);
    }

    Corona(GameObj gameObj, List list, int n, int n2, List list2) {
        this.player = gameObj;
        this.goss = list;
        this.width = n;
        this.height = n2;
        this.personen = list2;
    }
}

