/*
 * Decompiled with CFR 0.152.
 */
package name.panitz.game2d;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyEvent;
import javax.swing.JPanel;
import javax.swing.Timer;
import name.panitz.game2d.Game;

public class SwingScreen
extends JPanel {
    private static final long serialVersionUID = 1403492898373497054L;
    Game logic;
    Timer t;
    KeyEventDispatcher ev = null;

    public SwingScreen(Game gl) {
        this.logic = gl;
        this.t = new Timer(13, ev -> {
            this.logic.move();
            this.logic.doChecks();
            this.repaint();
            this.getToolkit().sync();
            this.requestFocus();
        });
        this.t.start();
        this.ev = new KeyEventDispatcher(){

            @Override
            public boolean dispatchKeyEvent(KeyEvent ke) {
                SwingScreen.this.logic.keyPressedReaction(ke);
                return false;
            }
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.ev);
        this.setFocusable(true);
        this.requestFocus();
    }

    @Override
    public void disable() {
        if (this.ev == null) {
            return;
        }
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.ev);
        this.ev = null;
        this.t.stop();
        this.t = null;
    }

    public Timer getTimer() {
        return this.t;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.logic.width(), this.logic.height());
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.logic.paintTo(g);
    }
}

