/*
 * Decompiled with CFR 0.152.
 */
package name.panitz.game2d;

import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import name.panitz.game2d.GameObj;
import name.panitz.game2d.Vertex;

public record ImageObject(Vertex pos, Vertex velocity, double width, double height, String fileName, Image image) implements GameObj
{
    public ImageObject(Vertex pos, Vertex velocity, double width, double height, String fileName, Image image) {
        ImageIcon iIcon = new ImageIcon(this.getClass().getClassLoader().getResource(fileName));
        width = iIcon.getIconWidth();
        height = iIcon.getIconHeight();
        image = iIcon.getImage();
        this.fileName = fileName;
        this.height = height;
        this.image = image;
        this.pos = pos;
        this.velocity = velocity;
        this.width = width;
    }

    public ImageObject(Vertex pos, Vertex velocity, String fileName) {
        this(pos, velocity, 0.0, 0.0, fileName, null);
    }

    public ImageObject(String fileName) {
        this(new Vertex(0.0, 0.0), new Vertex(0.0, 0.0), fileName);
    }

    @Override
    public void paintTo(Graphics g) {
        g.drawImage(this.image, (int)this.pos.x, (int)this.pos.y, null);
    }
}

