/*
 * Decompiled with CFR 0.152.
 */
package name.panitz.game2d;

import java.awt.Graphics;
import name.panitz.game2d.Vertex;

public interface GameObj {
    public Vertex pos();

    public Vertex velocity();

    public double width();

    public double height();

    default public void paintTo(Graphics g) {
    }

    default public void move() {
        this.pos().add(this.velocity());
    }

    default public boolean isAbove(double y) {
        return this.pos().y + this.height() < y;
    }

    default public boolean isAbove(GameObj that) {
        return this.isAbove(that.pos().y);
    }

    default public boolean isUnderneath(GameObj that) {
        return that.isAbove(this);
    }

    default public boolean isLeftOf(double x) {
        return this.pos().x + this.width() < x;
    }

    default public boolean isLeftOf(GameObj that) {
        return this.isLeftOf(that.pos().x);
    }

    default public boolean isRightOf(GameObj that) {
        return that.isLeftOf(this);
    }

    default public boolean touches(GameObj that) {
        return !this.isAbove(that) && !this.isUnderneath(that) && !this.isLeftOf(that) && !this.isRightOf(that);
    }

    default public boolean isStandingOnTopOf(GameObj that) {
        return !this.isLeftOf(that) && !this.isRightOf(that) && this.isAbove(that) && this.pos().y + this.height() + this.velocity().y + 1.5 > that.pos().y;
    }
}

