/*
 * Decompiled with CFR 0.152.
 */
package name.panitz.game2d;

import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.JFrame;
import name.panitz.game2d.GameObj;
import name.panitz.game2d.SwingScreen;

public interface Game {
    public int width();

    public int height();

    public GameObj player();

    public List<List<? extends GameObj>> goss();

    public void init();

    public void doChecks();

    public void keyPressedReaction(KeyEvent var1);

    default public void move() {
        if (this.ended()) {
            return;
        }
        for (List<? extends GameObj> gos : this.goss()) {
            gos.forEach(go -> go.move());
        }
        this.player().move();
    }

    public boolean won();

    public boolean lost();

    default public boolean ended() {
        return this.won() || this.lost();
    }

    default public void paintTo(Graphics g) {
        for (List<? extends GameObj> gos : this.goss()) {
            gos.forEach(go -> go.paintTo(g));
        }
        this.player().paintTo(g);
    }

    default public void play() {
        this.init();
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.add(new SwingScreen(this));
        f.pack();
        f.setVisible(true);
    }
}

