/*
 * Decompiled with CFR 0.152.
 */
package name.panitz.game2d;

import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import name.panitz.game2d.AbstractGameObj;
import name.panitz.game2d.Vertex;

public class FallingImage
extends AbstractGameObj {
    static double G = 9.81;
    double v0;
    int t = 0;
    Image image;
    public boolean isJumping = false;

    public FallingImage(String imageFileName, Vertex corner, Vertex movement) {
        super(corner, movement, 0.0, 0.0);
        ImageIcon iIcon = new ImageIcon(this.getClass().getClassLoader().getResource(imageFileName));
        this.width = iIcon.getIconWidth();
        this.height = iIcon.getIconHeight();
        this.image = iIcon.getImage();
    }

    public void stop() {
        this.pos().add(this.velocity().mult(-1.1));
        this.velocity().x = 0.0;
        this.velocity().y = 0.0;
        this.isJumping = false;
    }

    public void restart() {
        double oldX = this.velocity().x;
        this.pos().add(this.velocity().mult(-1.1));
        this.velocity().x = oldX;
        this.velocity().y = 0.0;
        this.isJumping = false;
    }

    public void left() {
        if (!this.isJumping) {
            this.velocity().x = -1.0;
        }
    }

    public void right() {
        if (!this.isJumping) {
            this.velocity().x = 1.0;
        }
    }

    public void jump() {
        if (!this.isJumping) {
            this.startJump(-3.5);
        }
    }

    public void startJump(double v0) {
        this.isJumping = true;
        this.v0 = v0;
        this.t = 0;
    }

    @Override
    public void move() {
        if (this.isJumping) {
            double v;
            ++this.t;
            this.velocity().y = v = this.v0 + G * (double)this.t / 200.0;
        }
        super.move();
    }

    @Override
    public void paintTo(Graphics g) {
        g.drawImage(this.image, (int)this.pos.x, (int)this.pos.y, null);
    }
}

