/*
 * Decompiled with CFR 0.152.
 */
package name.panitz.game2d;

import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;

public class AudioFilePlayer {
    private Clip clip = null;
    int framepos = 0;
    boolean wasstoped = false;
    boolean wasstarted = false;
    boolean loop = false;

    public void stop() {
        if (this.clip == null) {
            System.out.println("clip not supported...");
            return;
        }
        this.wasstoped = true;
        this.clip.stop();
    }

    public boolean isPlaying() {
        if (this.clip == null) {
            return false;
        }
        return this.clip.isRunning() || this.loop;
    }

    public void setVolume(double volume) {
        if (this.clip == null) {
            System.out.println("clip not supported...");
            return;
        }
        if (volume < 0.0 || volume > 1.0) {
            throw new IllegalArgumentException("Volume not valid: " + volume);
        }
        FloatControl gainControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
        gainControl.setValue(20.0f * (float)Math.log10(volume));
    }

    public void pause() {
        if (this.clip == null) {
            System.out.println("clip not supported...");
            return;
        }
        this.framepos = this.clip.getFramePosition();
        this.clip.stop();
    }

    public void resume() {
        if (this.wasstoped) {
            return;
        }
        if (this.clip == null) {
            System.out.println("clip not supported...");
            return;
        }
        this.clip.setFramePosition(this.framepos);
        this.clip.start();
    }

    public void play() {
        if (this.clip == null) {
            System.out.println("clip not supported...");
            return;
        }
        this.clip.start();
    }

    public void play(String file, boolean loop) {
        try {
            this.clip = AudioSystem.getClip();
            this.clip.open(AudioSystem.getAudioInputStream(this.getClass().getClassLoader().getResource(file)));
            if (loop) {
                this.clip.loop(-1);
            }
            this.clip.start();
            this.loop = loop;
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public double getVolume() {
        if (this.clip == null) {
            System.out.println("clip not supported...");
            return 0.0;
        }
        FloatControl gainControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
        return Math.pow(10.0, gainControl.getValue() / 20.0f);
    }
}

